#define _GNU_SOURCE
#include <string.h>
#include <stdlib.h>
#include <err.h>
#include <limits.h>
#include <assert.h>

#include "data.h"
#include "error.h"

#define DATA_MAX_LEN (INT_MAX-1)

struct sData {
  char *string;
  size_t len;
};


Data 
data_fromString (char *s){
  Data ret;

  assert(s != NULL);

  ret = (Data) malloc(sizeof(struct sData));

  if (ret == NULL)
    err(EXIT_FAILURE, ERRFMT, "data_fromString",__LINE__);

  ret->len = strnlen(s, DATA_MAX_LEN);

  ret->string = (char *) calloc(ret->len + 1, sizeof(char));

  if (ret->string == NULL)
    err(EXIT_FAILURE, ERRFMT, "data_fromString",__LINE__);

  strncpy (ret->string, s, ret->len + 1);

  ret->string[ret->len] = '\0';

  return ret;

}

char *
data_toString (Data d){
  char * ret;
  
  assert(d != NULL);

  ret = (char *) calloc(d->len + 1, sizeof(char));

  if (ret == NULL)
    err(EXIT_FAILURE, ERRFMT, "data_toString",__LINE__);

  strncpy (ret, d->string, d->len + 1);

  return ret;
}

int 
data_lenght (Data d) {
  assert(d != NULL);
  return d->len;
}

Data 
data_clone (Data d){
  assert(d != NULL);
  return data_fromString(d->string);
}

Data 
data_destroy(Data d){
  if (d == NULL)
    err(EXIT_FAILURE, "Destructor con puntero NULL. " ERRFMT, 
        "data_destroy",__LINE__);
  free(d->string);
  free(d);
  return NULL;
}


