#define _GNU_SOURCE
#include <string.h>
#include <stdlib.h>
#include <err.h>
#include <assert.h>

#include "key.h"
#include "error.h"

#define KEY_MAX_LENGH 40

struct sKey {
    char string[KEY_MAX_LENGH + 1];
};


int 
key_maxLen (void) {
    return KEY_MAX_LENGH;
}

Key 
key_fromString (char *s) {
    Key ret;

    assert(s != NULL);

    ret = (Key) malloc(sizeof(struct sKey));

    if (ret == NULL)
      err(EXIT_FAILURE, ERRFMT, "key_fromString",__LINE__);

    strncpy (ret->string, s, KEY_MAX_LENGH+1);
    ret->string[KEY_MAX_LENGH] = '\0';

    return ret;
}

void 
key_toString (Key k, char *s) {
    assert(k != NULL);
    assert(s != NULL);
    strncpy (s, k->string, KEY_MAX_LENGH+1);
}

int 
key_length (Key k) {
  assert(k != NULL);
  return (strnlen (k->string, KEY_MAX_LENGH+1));
}

int 
key_eq (Key k1, Key k2) {
  assert(k1 != NULL);
  assert(k2 != NULL);
  return (strncmp (k1->string, k2->string, KEY_MAX_LENGH)==0);
}

int 
key_le (Key k1, Key k2) {
  assert(k1 != NULL);
  assert(k2 != NULL);
  return (strncmp (k1->string, k2->string, KEY_MAX_LENGH)<0);
}

Key
key_clone (Key k) {
  assert(k != NULL);
  return key_fromString(k->string);
}

Key 
key_destroy(Key k){
  if (k == NULL)
    err(EXIT_FAILURE, "Destructor con puntero NULL. " ERRFMT, 
        "key_destroy",__LINE__);
  free(k);
  return NULL;
}


