#ifndef KEY_H
#define KEY_H

#include "bool.h"

typedef struct sKey * Key;

/* devuelve el largo mximo definido por KEY_MAX_LENGH */
int 
key_maxLen (void);

/* construye un Key desde un string */
Key 
key_fromString (char *s);

/* convierte un Key a string */
void 
key_toString (Key k, char *s);

/* devuelve la longitud del string en k */
int 
key_length (Key k);

/* pregunta si las claves son iguales */
Bool 
key_eq (Key k1, Key k2);

/* pregunta si la primera clave es menor que la segunda */
Bool 
key_le (Key k1, Key k2);

/* devuelve un copia */
Key 
key_clone (Key k);

/* Destructor */
Key 
key_destroy(Key k);


#endif
