#include <stdio.h>
#include <stdlib.h>
/* #include <mcheck.h> */
#include <string.h>
#include <err.h>
#include "./lib/cr.h"
#include "./lib/cw.h"

char *
strclone(const char* str);


int main(int ARGC, char *ARGV[]){
  cr c1;
  cw c2;
  char * nomarchin, * nomarchout;
  Tuple e;
  int cant;

/* #ifndef NDEBUG */
/*   mtrace (); */
/* #endif */


  if ( ARGC > 1)
    nomarchin = ARGV[1];
  else
    nomarchin = strclone("pru.txt");

  c1 = cr_create(nomarchin);

  if (c1 == NULL)
    errx(EXIT_FAILURE, "Error al crear cinta de lectura"
	 ", archivo %s, linea %i", __FILE__, __LINE__);

  if ( ARGC > 2)
    nomarchout = ARGV[2];
  else
    nomarchout = strclone("pruw.txt");;

  c2 = cw_create(nomarchout);


  if (c2 == NULL){
    c1 = cr_destroy(c1);
    errx(EXIT_FAILURE, "Error al crear cinta de escritura" 
	 ", archivo %s, linea %i", __FILE__, __LINE__);
  }

  cant = 0;
  cr_arr(c1);

  cw_arr(c2);

  while (!cr_fin(c1)){

    e = cr_elec(c1);

    cw_ins(c2, e);

    e = tuple_destroy(e);

    cant = cant+1;

    printf("Grabada palabra : %d\n",cant);

    cr_av(c1);

  }

  c1 = cr_destroy(c1);
  c2 = cw_destroy(c2);

  printf("Copiado %s -> %s\n",nomarchin,nomarchout);

  printf("Cantidad de palabras en el diccionario %s: %d\n",nomarchin, cant);

  if ( ARGC <= 1)
    free(nomarchin);

  if ( ARGC <= 2)
    free(nomarchout);

  return EXIT_SUCCESS;
}

char * strclone(const char* str){
  char * res;

  res = (char *) calloc(strlen(str)+1,sizeof(char));

  strcpy(res,str);

  return res;
}

