#include <stdlib.h>
#include <err.h>
#include <assert.h>

#include <assert.h>
#include "tuple.h"
#include "key.h"
#include "data.h"
#include "error.h"

struct sTuple {
    Key key;
    Data data;
};

Tuple 
tuple_fromKeyData (Key k, Data d){
  Tuple ret;

  assert(k != NULL);
  assert(d != NULL);

  ret = (Tuple) malloc(sizeof(struct sTuple));

  if (ret == NULL)
    err(EXIT_FAILURE, ERRFMT, "tuple_fromKeyData",__LINE__);

  ret->key = k;
  ret->data = d;

  return ret;
}

Key 
tuple_fst (Tuple t){

  assert(t != NULL);

  return t->key;

}

Data 
tuple_snd (Tuple t){
  assert(t != NULL);

  return t->data;

}

Tuple 
tuple_clone (Tuple t){
  assert(t != NULL);
  return tuple_fromKeyData(key_clone(t->key),data_clone(t->data));
}

Tuple 
tuple_destroy(Tuple t){
  if (t == NULL)
    err(EXIT_FAILURE, "Destructor con puntero NULL. " ERRFMT, 
        "tuple_destroy",__LINE__);

  assert(t->key != NULL);
  assert(t->data != NULL);

  key_destroy(t->key);
  data_destroy(t->data);

  free(t);

  return NULL;
  
}
