module AList (List,
                aList_null,
                aList_adjoin,
                aList_isNull,
                aList_head,
                aList_tail,
                aList_equal
               ) where

data List a = Nil | Cell a (List a) -- deriving Show

-- Constructores
aList_null :: List a
aList_adjoin :: (a ,List a) -> List a

-- Proyectores
aList_isNull :: List a -> Bool
aList_head :: List a -> a
aList_tail :: List a -> List a
aList_equal :: Eq a => (List a , List a) -> Bool

aList_null = Nil

aList_adjoin (x,l) = Cell x l

aList_isNull l = case l of 
                   Nil -> True 
                   _   -> False

aList_head l = case l of
                   Nil -> error "..."
                   Cell x _ -> x

aList_tail l = case l of
                   Nil -> error "..."
                   Cell _ l' -> l'

aList_equal (l, m) =  case l of
                          Nil -> aList_isNull m
                          Cell x l' -> not (aList_isNull m)
                                       && x == aList_head m
                                       && aList_equal (l',aList_tail m)

-- AList> aList_head (aList_tail (aList_adjoin(3,aList_adjoin(4,aList_null))))
-- 4
