#include <stdlib.h>
#include "aList.h"

struct cell {
  alpha elem;
  struct cell * tl; 
};

aList
aList_null(void){
  return NULL;
}

aList
aList_adjoin(alpha x, aList l){
  aList new;

  new = (aList) malloc(sizeof(struct cell));

  new->elem = x;

  new->tl = l;

  return new;
  
}

bool
aList_isNull(aList l){
  return (l==NULL);
}

alpha
aList_head(aList l){
  alpha res;

  if (l == NULL) 
    exit(1);
  else 
    res = l->elem;

  return res;
}

aList
aList_tail(aList l){
  aList tail;

  if (l == NULL) 
    exit(1);
  else 
    tail = l->tl;

  return tail;
}

bool
aList_equal(aList l, aList m){
  bool res;

  if (l == NULL) 
    res = (m == NULL);
  else
    res = ! aList_isNull(m) 
      && l->elem == aList_head(m)
      && aList_equal(l->tl, aList_tail (m));

  return res;

}

aList
aList_destroy(aList l){
  aList laux;
  
  while (l != NULL){
    
    laux = l->tl;
    free(l);
    l = laux;
  }

  return NULL;
}
